<?php
/* --------------------------------------------------------------
  EanCollectionDto.php 2020-02-25
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitEan\Repository\Dto;

use ArrayAccess;
use Countable;
use InvalidArgumentException;
use Iterator;
use JsonSerializable;

/**
 * Class EanCollectionDto
 * @package Gambio\Shop\Attributes\SellingUnitEan\Repository\Dto
 */
class EanCollectionDto implements Countable, Iterator, ArrayAccess, JsonSerializable
{
    /**
     * @var EanDto[]
     */
    protected $values = [];
    
    /**
     * @var int
     */
    protected $position = 0;
    
    
    /**
     * EanCollectionDto constructor.
     *
     * @param array $eanValues
     */
    public function __construct(array $eanValues = [])
    {
        if (count($eanValues)) {
            foreach ($eanValues as $eanValue) {
                $this[] = $eanValue;
            }
        }
    }
    
    
    /**
     * @inheritDoc
     */
    public function current() : EanDto
    {
        return $this->values[$this->position];
    }
    
    
    /**
     * @inheritDoc
     */
    public function next() : void
    {
        $this->position++;
    }
    
    
    /**
     * @inheritDoc
     */
    public function key() : int
    {
        return $this->position;
    }
    
    
    /**
     * @inheritDoc
     */
    public function valid() : bool
    {
        return isset($this->values[$this->position]);
    }
    
    
    /**
     * @inheritDoc
     */
    public function rewind() : void
    {
        $this->position = 0;
    }
    
    
    /**
     * @inheritDoc
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->values[$offset]);
    }
    
    
    /**
     * @inheritDoc
     */
    public function offsetGet($offset)
    {
        return $this->values[$offset];
    }
    
    
    /**
     * @inheritDoc
     */
    public function offsetSet($offset, $value) : void
    {
        if (!$value instanceof EanDto) {
            throw new InvalidArgumentException(static::class . ' only accepts ' . EanDto::class);
        }
        if (empty($offset)) {
            $this->values[] = $value;
        } else {
            $this->values[$offset] = $value;
        }
    }
    
    
    /**
     * @inheritDoc
     */
    public function offsetUnset($offset) : void
    {
        unset($this->values[$offset]);
    }
    
    
    /**
     * @inheritDoc
     */
    public function count() : int
    {
        return count($this->values);
    }
    
    
    /**
     * @inheritDoc
     */
    public function jsonSerialize() : array
    {
        return $this->values;
    }
}